import type { Spel } from './model';

import type { ID, PageQuery, PageResult } from '#/api/baseModel';

import { requestClient } from '#/api/request';

export function spelList(params?: PageQuery) {
  return requestClient.get<PageResult<Spel>>('/workflow/spel/list', { params });
}

export function spelInfo(id: ID) {
  return requestClient.get<Spel>(`/workflow/spel/${id}`);
}

export function spelAdd(data: Partial<Spel>) {
  return requestClient.post<Spel>('/workflow/spel', data, {
    successMessageMode: 'message',
  });
}

export function spelUpdate(data: Partial<Spel>) {
  return requestClient.put<Spel>('/workflow/spel', data, {
    successMessageMode: 'message',
  });
}

export function spelDelete(ids: ID[]) {
  return requestClient.delete<Spel>(`/workflow/spel/${ids}`, {
    successMessageMode: 'message',
  });
}
