import type { BaseModel, PageQuery } from '#/api/baseModel';

import { requestClient } from '#/api/request';

export namespace DictTypeApi {
  export interface DictType extends BaseModel {
    /**
     * 字典名称
     */
    dictName: string;

    /**
     * 字典类型
     */
    dictType: string;

    /**
     * 描述
     */
    description?: string;

    /**
     * 备注
     */
    remark?: string;
  }
}

/**
 * 查询字典类型列表
 * @param query
 * @returns {*}
 */

export function apiPage(params: PageQuery) {
  return requestClient.get('/system/dict/type/page', { params });
}

/**
 * 查询字典类型详细
 * @param id
 */
export function apiDetail(id: number) {
  return requestClient.get(`/system/dict/type/detail/${id}`);
}

/**
 * 新增字典类型
 * @param data
 */
export function apiAdd(data: DictTypeApi.DictType) {
  return requestClient.post('/system/dict/type', data);
}

/**
 * 修改字典类型
 * @param data
 */
export function apiUpdate(data: DictTypeApi.DictType) {
  return requestClient.put('/system/dict/type', data);
}

/**
 * 删除字典类型
 * @param id
 */
export function apiDelete(id: Array<number> | number) {
  return requestClient.delete(`/system/dict/type/${id}`);
}
/**
 * 导出字典类型
 * @params query
 */
export function apiExport(params?: PageQuery) {
  return requestClient.post('/system/dict/type/export', params);
}

/**
 * 导出字典类型
 */
export function apiOptionselect() {
  return requestClient.get('/system/dict/type/optionselect');
}

/**
 * 刷新字典缓存
 * @returns void
 */
export function refreshDictTypeCache() {
  return requestClient.delete('/system/dict/type/refreshCache', {
    successMessageMode: 'message',
  });
}
