import type { BaseModel, PageQuery } from '#/api/baseModel';

import { commonExport } from '#/api/helper';
import { requestClient } from '#/api/request';

export namespace SysUserApi {
  export interface User extends BaseModel {
    isEnable?: number;
    deptId?: number;
    name?: string;
    username?: string;
    password?: string;
    email?: string;
    phone?: string;
    remark?: string;
    userType?: string;
    jobType?: string;
    mallId?: number;
    roleIds?: number[];
  }

  // export interface SysUserDetailSaveParam {
  //   sysUser: User;
  //   password?: string;
  //   roleIds?: number[];
  // }

  // export interface SysUserModifyPasswordParam {
  //   sysUser: User;
  //   password: string;
  // }
}
export function getUserList(params: PageQuery) {
  return requestClient.get('/system/user/findList', { params });
}

export function enableUser(data: SysUserApi.User) {
  return requestClient.put('/system/user/isEnableRole', data);
}

export function deleteUser(id: number) {
  return requestClient.delete(`/system/user/${id}`);
}

// export function getMenuList() {
//   return requestClient.post('/system/adminMenu/tree');
// }

// export function getInfo() {
//   return requestClient.get('/userinfo');
// }

export function getUserDetail(id: number) {
  return requestClient.get(`/system/user/${id}`);
}

/**
 * 新增系统用户
 * @param data
 */
export function apiAdd(data: SysUserApi.User) {
  return requestClient.post('/system/user', data);
}
/**
 * 修改系统用户
 * @param data
 */
export function apiUpdate(data: SysUserApi.User) {
  return requestClient.put('/system/user', data);
}

// export function saveUser(data: SysUserApi.SysUserDetailSaveParam) {
//   return requestClient.post('/system/user/saveUser', data);
// }

export function resetPassword(data: SysUserApi.User) {
  return requestClient.put('/system/user/resetPassword', data);
}

// export function generatePassword(data: DetailParam) {
//   return requestClient.post('/system/user/generatePassword', data);
// }

// export function changeUserStatus(data: SysUserApi.User) {
//   return requestClient.post('/system/user/changeUserStatus', { entity: data });
// }

export function isEnable(data: SysUserApi.User) {
  return requestClient.post('/system/user/isEnableRole', data);
}

/**
 * 导出用户
 * @param params
 */
export function userExportData(params: PageQuery) {
  return commonExport('/system/user/export', params);
}

/**
 * 下载用户导入模板
 * @returns blob
 */
export function downloadImportTemplate() {
  return commonExport('/system/user/importTemplate', {});
}

/**
 * 从excel导入用户
 * @param file
 * @returns void
 */
export function userImportData(file: Blob) {
  return requestClient.post<{ errMessage: string; success: boolean }>(
    '/system/user/import',
    { file },
    {
      headers: {
        'Content-Type': 'multipart/form-data;charset=UTF-8',
      },
      isTransformResponse: false,
      responseReturn: 'body',
    },
  );
}
