import type { VbenFormSchema } from '#/adapter/form';
import type { OnActionClickFn, VxeTableGridOptions } from '#/adapter/vxe-table';
import type { DictApi } from '#/api/system/dict/dict';

export const querySchema: VbenFormSchema[] = [
  {
    component: 'Input',
    fieldName: 'dictName',
    label: '字典名称',
  },
  {
    component: 'Input',
    fieldName: 'dictType',
    label: '字典类型',
  },
];

export function useColumns(
  onActionClick: OnActionClickFn<DictApi.Dict>,
): VxeTableGridOptions<DictApi.Dict>['columns'] {
  return [
    {
      title: '字典名称',
      field: 'dictName',
      width: 100,
    },
    {
      title: '字典类型',
      field: 'dictType',
      width: 150,
    },
    {
      title: '描述',
      field: 'description',
    },
    {
      title: '备注',
      field: 'remark',
    },
    {
      align: 'right',
      cellRender: {
        attrs: {
          nameField: 'dictName',
          nameTitle: '字典类型',
          onClick: onActionClick,
        },
        name: 'CellOperation',
        options: [
          {
            code: 'edit',
            accessCode: ['system:dict:edit'],
          }, // 默认的编辑按钮
          {
            code: 'delete',
            accessCode: ['system:dict:remove'],
          }, // 默认的删除按钮
        ],
      },
      field: 'action',
      fixed: 'right',
      headerAlign: 'center',
      resizable: false,
      showOverflow: false,
      title: '操作',
      width: 'auto',
    },
  ];
}
