import { computed } from 'vue';

import { apiGetDicts } from '#/api/system/dict/dictItem';
import { useDictStore } from '#/store/dict';

/**
 * 一般是Select, Radio, Checkbox等组件使用
 * @warning 注意内部为异步实现 所以不要写这种`getDictOptions()[0]`的代码 会获取不到
 * @warning 需要保持`formatNumber`统一 在所有调用地方需要一致 不能出现A处为string B处为number
 *
 * @param dictName 字典名称
 * @param formatNumber 是否格式化字典value为number类型
 * @returns Options数组
 */
export function getDictOptions(dictName: string, formatNumber = false) {
  const { dictRequestCache, setDictInfo, getDictOptions } = useDictStore();
  const dataList = getDictOptions(dictName);

  // 检查请求状态缓存
  if (dataList.length === 0 && !dictRequestCache.has(dictName)) {
    dictRequestCache.set(
      dictName,
      apiGetDicts(dictName)
        .then((resp) => {
          // 缓存到store 这样就不用重复获取了
          // 内部处理了push的逻辑 这里不用push
          setDictInfo(dictName, resp, formatNumber);
        })
        .catch(() => {
          // 401时 移除字典缓存 下次登录重新获取
          dictRequestCache.delete(dictName);
        })
        .finally(() => {
          // 移除请求状态缓存
          /**
           * 这里主要判断字典item为空的情况(无奈兼容 不给字典item本来就是错误用法)
           * 会导致if一直进入逻辑导致接口无限刷新
           * 在这里dictList为空时 不删除缓存
           */
          if (dataList.length > 0) {
            dictRequestCache.delete(dictName);
          }
        }),
    );
  }
  return dataList;
}

// /**
//  * 这里是提供给渲染标签使用的方法
//  * @deprecated 使用getDictOptions代替 于下个版本删除
//  * @param dictName 字典名称
//  * @returns 字典信息
//  */
// export function getDict(dictName: string) {
//   const { getDictOptions } = useDictStore();
//   return getDictOptions(dictName);
// }

// /**
//  * 一般是Select, Radio, Checkbox等组件使用
//  * @param dictName 字典名称
//  * @param formatNumber 是否格式化字典value为number类型
//  * @returns Options数组
//  */
// export function getDictOptions(dictName: string, formatNumber = false) {
//   const { getDictOptions } = useDictStore();
//   return fetchAndCacheDictData(
//     dictName,
//     () => getDictOptions(dictName),
//     formatNumber,
//   );
// }

export function getTagDicts(dictName: string, formatNumber = false) {
  // const { getDictOptions } = useDictStore();
  const dictOptions = getDictOptions(dictName, formatNumber);
  return computed(() => {
    if (!dictOptions) return [];
    return dictOptions.map((item) => ({
      label: item.label,
      value: item.value,
      color: item.listClass,
    }));
  });
  // console.log('[33]', dictName, JSON.parse(JSON.stringify(dictOptions)));
  // if (!dictOptions) return [];
}
