import type { BaseModel, PageQuery } from '#/api/baseModel';

import { commonExport } from '#/api/helper';
import { requestClient } from '#/api/request';

export namespace NoticeApi {
  export interface Notice extends BaseModel {
    /**
     * 公告标题
     */
    noticeTitle?: string;
    /**
     * 公告类型（1通知 2公告）
     */
    noticeType?: string;
    /**
     * 公告内容
     */
    noticeContent?: string;
    /**
     * 公告状态（1正常 0关闭）
     */
    status?: number;

    /**
     * 备注
     */
    remark?: string;
    /**
     * 创建部门
     */
    createDept?: number;
  }
}

/**
 * 查询通知公告列表
 * @param params
 * @returns {*} page
 */
export function apiPage(params: PageQuery) {
  return requestClient.get('/system/notice/page', { params });
}
/**
 * 查询通知公告详细
 * @param id
 */
export function apiDetail(id: number) {
  return requestClient.get(`/system/notice/${id}`);
}
/**
 * 新增通知公告
 * @param data
 */
export function apiAdd(data: NoticeApi.Notice) {
  return requestClient.post('/system/notice', data);
}
/**
 * 修改通知公告
 * @param data
 */
export function apiUpdate(data: NoticeApi.Notice) {
  return requestClient.put('/system/notice', data);
}
/**
 * 删除通知公告
 * @param id
 */
export function apiDelete(id: Array<number> | number) {
  return requestClient.delete(`/system/notice/${id}`);
}
/**
 * 导出通知公告
 * @param params
 */
export function apiExport(params: PageQuery) {
  return commonExport('/system/notice/export', params);
}
