import type { VbenFormSchema } from '#/adapter/form';
import type { OnActionClickFn, VxeTableGridOptions } from '#/adapter/vxe-table';
import type { SysConfigApi } from '#/api/system/sysConfig';

export const querySchema: VbenFormSchema[] = [
  {
    component: 'Input',
    fieldName: 'configName',
    label: '参数名称',
  },
  {
    component: 'Input',
    fieldName: 'configKey',
    label: '参数键名',
  },
  {
    component: 'Input',
    fieldName: 'configValue',
    label: '参数键值',
  },
];

export function useColumns(
  onActionClick: OnActionClickFn<SysConfigApi.Config>,
): VxeTableGridOptions<SysConfigApi.Config>['columns'] {
  return [
    {
      title: '参数名称',
      field: 'configName',
      // width: 120,
    },
    {
      title: '参数键名',
      field: 'configKey',
      // width: 120,
    },
    {
      title: '参数键值',
      field: 'configValue',
      // width: 120,
    },
    {
      title: '备注',
      field: 'remark',
      // width: 120,
    },
    {
      align: 'right',
      cellRender: {
        attrs: {
          nameField: 'configName',
          nameTitle: '参数配置',
          onClick: onActionClick,
        },
        name: 'CellOperation',
        options: [
          {
            code: 'edit',
            accessCode: ['system:config:edit'],
          }, // 默认的编辑按钮
          {
            code: 'delete',
            accessCode: ['system:config:remove'],
          }, // 默认的删除按钮
        ],
      },
      field: 'action',
      fixed: 'right',
      headerAlign: 'center',
      resizable: false,
      showOverflow: false,
      title: '操作',
      width: 'auto',
    },
  ];
}
