import type { BaseModel, PageQuery } from '#/api/baseModel';

import { requestClient } from '#/api/request';

export namespace DictItemApi {
  export interface DictItem extends BaseModel {
    /**
     * 字典类型
     */
    dictType?: string;
    /**
     * 字典标签
     */
    dictLabel: string;
    /**
     * 字典键值
     */
    dictValue: string;
    /**
     * 样式属性（其他样式扩展）
     */
    listClass?: string;
    /**
     * 排序
     */
    dictSort?: number;
    /**
     * 描述
     */
    description?: string;
  }
}

/**
 * 查询字典明细列表
 * @param params
 * @returns {*} page
 */
export function apiPage(params: PageQuery) {
  return requestClient.get('/system/dictItem/page', { params });
}
/**
 * 根据字典类型查询字典数据信息
 * @params dictType
 * @returns {*}
 */
export function apiGetDicts(dictType: string) {
  return requestClient.get(`/system/dictItem/type/${dictType}`);
}
/**
 * 查询字典明细详细
 * @param id
 */
export function apiDetail(id: number) {
  return requestClient.get(`/system/dictItem/${id}`);
}
/**
 * 新增字典明细
 * @param data
 */
export function apiAdd(data: DictItemApi.DictItem) {
  return requestClient.post('/system/dictItem', data);
}
/**
 * 修改字典明细
 * @param data
 */
export function apiUpdate(data: DictItemApi.DictItem) {
  return requestClient.put('/system/dictItem', data);
}
/**
 * 删除字典明细
 * @param id
 */
export function apiDelete(id: number) {
  return requestClient.delete(`/system/dictItem/${id}`);
}
/**
 * 导出字典明细
 * @param params
 */
export function apiExport(params: PageQuery) {
  return requestClient.post('/system/dictItem/export', params);
}
