import type { VbenFormSchema } from '#/adapter/form';
import type { VxeTableGridOptions } from '#/adapter/vxe-table';
import type { SysJobLogApi } from '#/api/system/sysJobLog';

import { DictEnum } from '@vben/constants';

import { getDictOptions } from '#/utils/dict';

export const querySchema: VbenFormSchema[] = [
  {
    component: 'Input',
    fieldName: 'jobId',
    label: '任务id',
  },
  {
    component: 'Input',
    fieldName: 'executorHandler',
    label: '执行器',
  },
  // {
  //   component: 'Input',
  //   fieldName: 'params',
  //   label: '参数',
  // },
  {
    component: 'Select',
    componentProps: {
      options: getDictOptions(DictEnum.SYS_SUCCESS_STATUS),
    },
    fieldName: 'status',
    label: '任务状态',
  },
  // {
  //   component: 'Input',
  //   fieldName: 'handleMsg',
  //   label: '执行信息',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'costTime',
  //   label: '执行耗时(单位：毫秒)',
  // },
  {
    component: 'RangePicker',
    fieldName: 'dateTime',
    label: '调度时间',
  },
];

export function useColumns(): VxeTableGridOptions<SysJobLogApi.SysJobLog>['columns'] {
  return [
    {
      title: '任务id',
      field: 'jobId',
    },
    {
      title: '执行器',
      field: 'executorHandler',
    },
    // {
    //   title: '参数',
    //   field: 'params',
    // },
    {
      title: '任务状态',
      field: 'status',
      slots: {
        default: 'status',
      },
    },
    {
      title: '执行信息',
      field: 'handleMsg',
    },
    {
      title: '耗时(单位：毫秒)',
      field: 'costTime',
    },
    {
      title: '调度时间',
      field: 'triggerTime',
      formatter: 'formatDateTime',
    },
    {
      align: 'right',
      // cellRender: {
      //   attrs: {
      //     nameField: 'executorHandler',
      //     nameTitle: '定时任务日志',
      //     onClick: onActionClick,
      //   },
      //   name: 'CellOperation',
      //   options: [
      //     {
      //       code: 'edit',
      //       accessCode: ['system:jobLog:edit'],
      //     }, // 默认的编辑按钮
      //     {
      //       code: 'delete',
      //       accessCode: ['system:jobLog:remove'],
      //     }, // 默认的删除按钮
      //   ],
      // },
      slots: { default: 'action' },
      field: 'action',
      fixed: 'right',
      headerAlign: 'center',
      resizable: false,
      showOverflow: false,
      title: '操作',
      width: 'auto',
    },
  ];
}
