import type { BaseModel, PageQuery } from '#/api/baseModel';

import { requestClient } from '#/api/request';

export namespace SysMenuApi {
  export interface menu extends BaseModel {
    /**
     * 父菜单ID
     */
    parentId?: number;

    /**
     * 菜单名称
     */
    name?: string;
    /**
     * 页面名称
     */
    pageName?: string;
    /**
     * 权限标识
     */
    perms?: string;
    /**
     * 菜单类型（0目录 1菜单 2按钮）
     */
    type?: number;

    // /**
    //  * 等级路径
    //  */
    // nodePath?: string;
    /**
     * 是否末级
     */
    isLeaf?: number;

    /**
     * Level
     */
    level?: number;

    /**
     * 菜单状态（0显示 1隐藏）
     */
    visible?: number;

    /**
     * 是否缓存（0缓存 1不缓存）
     */
    isCache?: number;

    /**
     * 显示顺序
     */
    orderNum?: number;
    children?: menu[];
  }
  /**
   * @description 菜单信息
   * @param label 菜单名称
   */
  export interface MenuOption {
    id: number;
    parentId: number;
    name: string;
    orderNum: number;
    children: MenuOption[];
    key: string; // 实际上不存在 ide报错
    type: number;
    // icon: string;
  }
}

export function findList(params: PageQuery) {
  return requestClient.get('/system/menu/list', { params });
}

export function deleteOne(id: number) {
  return requestClient.delete(`/system/menu/${id}`);
}

export function getDetail(id: number) {
  return requestClient.get(`/system/menu/detail/${id}`);
}

// export function saveOne(data: SysMenuApi.menu) {
//   return requestClient.post('/system/menu', { entity: data });
// }
/**
 * 新增菜单
 * @param data
 */
export function apiAdd(data: SysMenuApi.menu) {
  return requestClient.post('/system/menu', data);
}
/**
 * 修改菜单
 * @param data
 */
export function apiUpdate(data: SysMenuApi.menu) {
  return requestClient.put('/system/menu', data);
}

export function apiMenuTree() {
  return requestClient.get('/system/menu/tree');
}

export function apiMenuTreeSelect(data: SysMenuApi.menu) {
  return requestClient.get('/system/menu/treeselect', { data });
}
