package com.antai.sport.http.server.repository.sport.entity;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 运动记录汇总
 * </p>
 *
 * @author liming
 * @since 2021-09-26
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class SportUserSummary implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 汇总类型 1.骑行 2.跑步
     */
    private Integer type;

    /**
     * 用户id
     */
    private Long userId;

    /**
     * 总骑行距离
     */
    private BigDecimal totalDistance;

    /**
     * 总爬坡高度
     */
    private BigDecimal totalClimbDistance;

    /**
     * 总持续时长(秒)
     */
    private Integer totalDuration;

    /**
     * 版本号
     */
    private Long version;

    /**
     * 删除标记
     */
    private Integer deleted;

    /**
     * 创建时间
     */
    private LocalDateTime ctDate;

    /**
     * 修改人id
     */
    private Long lmUserId;

    /**
     * 修改时间
     */
    private LocalDateTime lmDate;


}
