package com.antai.sport.http.server.game.api.business.match.bicycle.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * @Author liming
 * @Date 2021/9/11 18:57
 * @Email lmmax@126.com
 * @Description:
 */
@Data
@ApiModel("比赛列表")
public class RespMatchBicycleList {
    @ApiModelProperty("比赛id")
    private Long id;
    @ApiModelProperty("比赛名称")
    private String name;
    @ApiModelProperty("允许进入时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime entryTime;
    @ApiModelProperty("开始比赛时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime startTime;
    @ApiModelProperty("比赛结束时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime endTime;
}
