package com.antai.sport.http.server.game.api.business.match.bicycle;

import com.antai.sport.http.server.constants.SportType;
import com.antai.sport.http.server.game.api.business.match.bicycle.dto.DtoMatchBicycleResult;
import com.antai.sport.http.server.game.api.business.sport.user.SportUserSummaryService;
import com.antai.sport.http.server.repository.match.entity.MatchBicyclePlayer;
import com.antai.sport.http.server.repository.match.mapper.MatchBicyclePlayerMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

/**
 * @Author liming
 * @Date 2021/9/11 18:32
 * @Email lmmax@126.com
 * @Description:
 */
@Service
public class MatchBicyclePlayerService extends ServiceImpl<MatchBicyclePlayerMapper, MatchBicyclePlayer> {
    @Resource
    private MatchBicycleBusinessMapper matchBicycleBusinessMapper;
    @Resource
    private SportUserSummaryService sportUserSummaryService;

    /**
     * 保存比赛结果
     *
     * @param resultList
     */
    @Transactional
    public void saveMatchBicyclePlayerRecord(List<DtoMatchBicycleResult> resultList) {
        if (resultList == null || resultList.isEmpty()) {
            return;
        }
        List<MatchBicyclePlayer> saveList = new ArrayList<>(resultList.size());
        for (DtoMatchBicycleResult item : resultList) {
            MatchBicyclePlayer record = new MatchBicyclePlayer();
            record.setMatchId(item.getMatchId());
            record.setUserId(item.getUserId());
            record.setEntryTime(item.getEntryTime());
            record.setFinishTime(item.getFinishTime());
            record.setDuration(item.getDuration());
            record.setMatchRank(item.getMatchRank());
            record.setClimbDistance(item.getClimbDistance());
            record.setDistance(item.getDistance());
            record.setAvgFtp(item.getAvgFtp());
            record.setAvgSpeed(item.getAvgSpeed());
            record.setStatus(item.getStatus());
            saveList.add(record);
            sportUserSummaryService.summary(item.getUserId(), SportType.BICYCLE, item.getDistance(), item.getClimbDistance(), item.getDuration());

        }
        this.saveBatch(saveList);
    }

    public List<DtoMatchBicycleResult> getMatchBicyclePlayerRecord(Long matchId) {
        return matchBicycleBusinessMapper.getMatchBicyclePlayerRecord(matchId);
    }
}
