package com.antai.sport.http.server.common.service;

import com.antai.sport.http.server.repository.sys.entity.SysCodeDetail;
import com.antai.sport.http.server.common.vo.SysCodeDetailVO;
import com.antai.sport.http.server.repository.sys.mapper.SysCodeDetailMapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
public class CommonCodeService {
    @Resource
    private SysCodeDetailMapper sysCodeDetailMapper;


    public Map<String, List<SysCodeDetailVO>> getCodeByTypes(String... codeType) {
        QueryWrapper<SysCodeDetail> queryWrapper = new QueryWrapper<>();
        queryWrapper.in("type_code", codeType);
        List<SysCodeDetail> detailList = sysCodeDetailMapper.selectList(queryWrapper);
        return process(detailList);
    }

    private Map<String, List<SysCodeDetailVO>> process(List<SysCodeDetail> detailList) {
        Map<String, List<SysCodeDetailVO>> resultMap = null;
        if (detailList != null && detailList.size() > 0) {
            resultMap = new HashMap<>(detailList.size());
            for (SysCodeDetail item : detailList) {
                if (!resultMap.containsKey(item.getTypeCode())) {
                    resultMap.put(item.getTypeCode(), new ArrayList<>());
                }
                resultMap.get(item.getTypeCode()).add(new SysCodeDetailVO(item));
            }
        }
        return resultMap;
    }
}
