package com.antai.sport.http.server.common.base;

/**
 * @Author liming
 * @Date 2021/8/20 11:31
 * @Email lmmax@126.com
 * @Description:
 */
public enum RespCodeEnum {
    SUCCESS("200", ""),
    PARAM_ERROR("001", "参数错误"),
    SYSTEM_ERROR("002", "系统错误"),
    SIGN_ERROR("003", "签名异常"),
    DATA_NOT_FOUND_ERROR("005", "查询数据不存在"),
    CONTROLLER_ERROR("004", "系统异常"),
    BUSINESS_ERROR("006", "业务异常"),
    DATA_CHANGE_ERROR("007", "当前数据已更新"),
    LOGIN_ERROR("401", "用户名或密码错误"),
    NOT_LOGIN("401", "未通过登录认证,请先进行登录"),
    TOKEN_EXPIRE("401", "当前Token已过期"),
    BIND_ERROR("402", "用户绑定错误"),
    DATA_AUTH_ERROR("403", "没有当前功能操作权限，请联系管理员");


    /**
     * 返回码
     */
    private String code;

    /**
     * 返回结果描述
     */
    private String message;

    RespCodeEnum(String code, String message) {
        this.code = code;
        this.message = message;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}
