package com.antai.sport.http.server.team.training.leader.api.business.teamtraining.service;

import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;

@Service
@Slf4j
public class TeamTrainingChangeNotifyService {
    @Value("${team-training-change-notify-url}")
    private String teamTrainingChangeNotifyUrl;
    @Resource
    private RestTemplate restTemplate;

    @Async("asyncTaskExecutor")
    public void notifyGameServerTeamTrainingChange() {
        log.info("异步通知比赛列表变更");
        String result = "执行失败";
        try {
            result = restTemplate.getForObject(teamTrainingChangeNotifyUrl, String.class);
        } catch (Exception ex) {
            log.error(ex.getMessage());
        }
        log.info("比赛变更结果：" + result);
    }
}
