package com.antai.sport.http.server.server.api.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;

public class ScoreUtils {

    public static BigDecimal calculate(BigDecimal oneMinutesFtp, BigDecimal fiveMinutesFtp, BigDecimal twentyMinutesFtp,
                                       BigDecimal oneMinutesWkg, BigDecimal fiveMinutesWkg, BigDecimal twentyMinutesWkg) {
        BigDecimal s1, s2, s3, s4, s5, s6;
        s1 = handeScore(oneMinutesFtp, BigDecimal.valueOf(1));
        s2 = handeScore(fiveMinutesFtp, BigDecimal.valueOf(1.1));
        s3 = handeScore(twentyMinutesFtp, BigDecimal.valueOf(1.4));
        s4 = handeScore(oneMinutesWkg, BigDecimal.valueOf(50));
        s5 = handeScore(fiveMinutesWkg, BigDecimal.valueOf(80));
        s6 = handeScore(twentyMinutesWkg, BigDecimal.valueOf(100));
        return s1.add(s2).add(s3).add(s4).add(s5).add(s6);
    }

    private static BigDecimal handeScore(BigDecimal value, BigDecimal coefficient) {
        BigDecimal result = value.multiply(coefficient).setScale(0, RoundingMode.HALF_UP);
        BigDecimal max = BigDecimal.valueOf(600);
        return result.compareTo(max) == 1 ? max : result;
    }
}
