package com.antai.sport.http.server.server.api.business.sportusergamecurrency.service;

import com.antai.sport.http.server.constants.GameCurrencyLogType;
import com.antai.sport.http.server.repository.shop.entity.SportUserGameCurrency;
import com.antai.sport.http.server.repository.shop.entity.SportUserGameCurrencyLog;
import com.antai.sport.http.server.repository.shop.mapper.SportUserGameCurrencyLogMapper;
import com.antai.sport.http.server.repository.shop.mapper.SportUserGameCurrencyMapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.time.LocalDateTime;

@Service
public class SportUserGameCurrencyService {
    @Resource
    private SportUserGameCurrencyMapper sportUserGameCurrencyMapper;
    @Resource
    private SportUserGameCurrencyLogMapper sportUserGameCurrencyLogMapper;

    public void addCurrency(Long sportUserId, Integer currency, Integer sourceType, Long sourceId) {
        SportUserGameCurrency userGameCurrency =
                sportUserGameCurrencyMapper.selectOne(new QueryWrapper<SportUserGameCurrency>().lambda()
                        .eq(SportUserGameCurrency::getSportUserId, sportUserId));


        if (userGameCurrency == null) {
            userGameCurrency = new SportUserGameCurrency();
            userGameCurrency.setSportUserId(sportUserId);
            userGameCurrency.setAmmount(currency);
            userGameCurrency.setCtDate(LocalDateTime.now());
            sportUserGameCurrencyMapper.insert(userGameCurrency);
        } else {
            userGameCurrency.setAmmount(userGameCurrency.getAmmount() + currency);
            sportUserGameCurrencyMapper.updateById(userGameCurrency);
        }
        SportUserGameCurrencyLog gameCurrencyLog = new SportUserGameCurrencyLog();
        gameCurrencyLog.setSportUserId(sportUserId);
        gameCurrencyLog.setAmmount(currency);
        gameCurrencyLog.setSourceType(sourceType);
        gameCurrencyLog.setSourceId(sourceId);
        gameCurrencyLog.setCtDate(LocalDateTime.now());
        gameCurrencyLog.setType(GameCurrencyLogType.ADD);
        sportUserGameCurrencyLogMapper.insert(gameCurrencyLog);
    }
}
