package com.antai.sport.http.server.server.api.business.club.controller;

import com.antai.sport.http.server.common.base.Result;
import com.antai.sport.http.server.server.api.business.club.dto.*;
import com.antai.sport.http.server.server.api.business.club.service.ClubService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

import static com.antai.sport.http.server.common.util.ResultUtil.success;

@RequestMapping("/club")
@RestController
@Api(tags = {"俱乐部"})
public class ClubController {
    @Resource
    private ClubService clubService;

    @ApiOperation("俱乐部-新建")
    @PostMapping
    public ResponseEntity<Result<Long>> create(@RequestBody CreateClubReqDTO dto) {
        return success(clubService.create(dto));
    }

    @ApiOperation("俱乐部-编辑")
    @PutMapping
    public ResponseEntity<Result> update(@RequestBody UpdateClubReqDTO dto) {
        clubService.update(dto);
        return success();
    }

    @ApiOperation("俱乐部通知-新建")
    @PostMapping("/notice")
    public ResponseEntity<Result<Long>> createClubNotice(@RequestBody CreateClubNoticeDTO dto) {
        return success(clubService.createClubNotice(dto));
    }

    @ApiOperation("俱乐部通知-编辑")
    @PutMapping("/notice")
    public ResponseEntity<Result> updateClubNotice(@RequestBody UpdateClubNoticeDTO dto) {
        clubService.updateClubNotice(dto);
        return success();
    }

    @ApiOperation("俱乐部通知-删除")
    @PostMapping("/notice/deleted")
    public ResponseEntity<Result> deleteClubNotice(@RequestBody DeleteClubNoticeDTO dto) {
        clubService.deleteClubNotice(dto);
        return success();
    }

    @ApiOperation("俱乐部-加入")
    @PostMapping("/join")
    public ResponseEntity<Result> join(@RequestBody JoinOrLeaveClubDTO dto) {
        clubService.join(dto);
        return success();
    }

    @ApiOperation("俱乐部-退出")
    @PostMapping("/leave")
    public ResponseEntity<Result> leave(@RequestBody JoinOrLeaveClubDTO dto) {
        clubService.leave(dto);
        return success();
    }

    @ApiOperation("俱乐部-列表")
    @PostMapping("/list")
    public ResponseEntity<Result<List<ClubRespDTO>>> getClubList(@RequestBody ClubListReqDTO dto) {
        return success(clubService.getList(dto));
    }

    @ApiOperation("俱乐部-玩家主页")
    @PostMapping("/home/{playerId}")
    public ResponseEntity<Result<PlayerClubHomeDTO>> getPlayerClubHome(@PathVariable("playerId") Long playerId) {
        return success(clubService.getPlayerClubHome(playerId));
    }

    @ApiOperation("俱乐部-主页")
    @PostMapping("/{clubId}")
    public ResponseEntity<Result<ClubHomeDTO>> getClubHome(@PathVariable("clubId") Long clubId) {
        return success(clubService.getClubHome(clubId));
    }

}
