package com.antai.sport.http.server.mobile.api.business.train.record.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
@ApiModel("训练记录")
public class ReqTrainRecord {
    @ApiModelProperty("运动类型: 1.骑行 2.跑步")
    private Integer sportType;
    @ApiModelProperty("开始时间 yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime startTime;
    @ApiModelProperty("结束时间 yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime endTime;
    @ApiModelProperty("骑行时长（秒）")
    private Integer duration;
    @ApiModelProperty("爬坡距离")
    private BigDecimal climbDistance;
    @ApiModelProperty("骑行总长度")
    private BigDecimal distance;
    @ApiModelProperty("平均功率 运动类型位骑行时赋值")
    private BigDecimal avgFtp;
    @ApiModelProperty("平均速度")
    private BigDecimal avgSpeed;
    @ApiModelProperty("配速 运动类型位跑步的时候赋值")
    private BigDecimal pace;

}
