package com.antai.sport.http.server.server.api.business.simplematch.converter;

import com.antai.sport.http.server.repository.simplematch.entity.SimpleMatch;
import com.antai.sport.http.server.repository.simplematch.entity.SimpleMatchBanner;
import com.antai.sport.http.server.repository.simplematch.entity.SimpleMatchPlayerRecord;
import com.antai.sport.http.server.server.api.business.simplematch.dto.ReqSimpleMatchInit;
import com.antai.sport.http.server.server.api.business.simplematch.dto.ReqSimpleMatchRecord;
import com.antai.sport.http.server.server.api.business.simplematch.dto.RespSimpleMatchBanner;
import com.antai.sport.http.server.server.api.business.simplematch.dto.RespSimpleMatchInfo;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;

import java.util.List;

@Mapper(componentModel = "spring")
public interface SimpleMatchConverter {
    SimpleMatch toSimpleMatch(ReqSimpleMatchInit data);

    List<RespSimpleMatchBanner> toRespBannerList(List<SimpleMatchBanner> bannerList);

    RespSimpleMatchInfo toRespSimpleMatchInfo(SimpleMatch source);

    @Mapping(source = "data.recordId", target = "id")
    @Mapping(source = "finished", target = "finished")
    SimpleMatchPlayerRecord toSimpleMatchPlayerRecord(ReqSimpleMatchRecord data, Boolean finished);
}
