package com.antai.sport.http.server.server.api.business.series.service;

import com.antai.sport.http.server.common.exception.BusinessException;
import com.antai.sport.http.server.repository.series.entity.Series;
import com.antai.sport.http.server.repository.series.entity.SeriesApply;
import com.antai.sport.http.server.repository.series.entity.SeriesRound;
import com.antai.sport.http.server.repository.series.mapper.SeriesApplyMapper;
import com.antai.sport.http.server.repository.series.mapper.SeriesMapper;
import com.antai.sport.http.server.repository.series.mapper.SeriesRoundMapper;
import com.antai.sport.http.server.repository.sport.entity.SportUser;
import com.antai.sport.http.server.repository.sport.mapper.SportUserMapper;
import com.antai.sport.http.server.server.api.business.base.mapper.BaseBusinessMapper;
import com.antai.sport.http.server.server.api.business.series.converter.SeriesConverter;
import com.antai.sport.http.server.server.api.business.series.dto.SeriesApplyDTO;
import com.antai.sport.http.server.server.api.business.series.mapper.SeriesBusinessMapper;
import com.antai.sport.http.server.server.api.business.series.vo.SeriesApplyPreLoadVO;
import com.antai.sport.http.server.server.api.business.series.vo.SeriesDetailsVO;
import com.antai.sport.http.server.server.api.business.series.vo.SeriesListVO;
import com.antai.sport.http.server.server.api.business.series.vo.SeriesQualifyingMatchHomeVO;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

@Service
public class SeriesService {

    @Resource
    private SeriesMapper seriesMapper;
    @Resource
    private SeriesApplyMapper seriesApplyMapper;
    @Resource
    private SeriesRoundMapper seriesRoundMapper;
    @Resource
    private SportUserMapper sportUserMapper;

    @Resource
    private SeriesConverter seriesConverter;

    @Resource
    private SeriesBusinessMapper seriesBusinessMapper;
    @Resource
    private BaseBusinessMapper baseBusinessMapper;

    public List<SeriesListVO> getSeriesList() {
        return seriesBusinessMapper.getSeriesList();
    }

    public SeriesDetailsVO getSeriesDetails(Long id, Long sportUserId) {
        Series series = seriesMapper.selectById(id);
        if (series == null) {
            throw new BusinessException("您查询的系列赛信息不存在");
        }
        LocalDateTime now = LocalDateTime.now();
        Integer status;
        if (series.getFinished()) {
            status = 40;
        } else if (now.isBefore(series.getApplyStartTime())) {
            status = 30;
        } else if (now.isAfter(series.getApplyStartTime()) && now.isBefore(series.getApplyEndTime())) {
            status = 10;
        } else {
            status = 20;
        }
        SeriesDetailsVO result = seriesConverter.toSeriesDetailVO(series, status);
        result.setNoticeList(seriesBusinessMapper.getSeriesNotice(id));
        result.setApplied(seriesBusinessMapper.checkExistUserSeriesApply(id, sportUserId));
        result.setRoundList(seriesBusinessMapper.getSeriesRound(id));
        result.setAreaList(seriesBusinessMapper.getSeriesAreaList(id));
        return result;
    }

    public SeriesApplyPreLoadVO getSeresApplyPreLoadInfo(Long sportUserId, Long seriesId) {
        SportUser sportUser = sportUserMapper.selectById(sportUserId);
        SeriesApplyPreLoadVO result = seriesConverter.toSeriesApplyPreLoadVO(sportUser);
        result.setAreaList(seriesBusinessMapper.getSeriesAreaList(seriesId));
        SeriesApply seriesApply = seriesBusinessMapper.getLatestUserSeriesApplyInfo(sportUserId);
        if (seriesApply != null) {
            result.setRealName(seriesApply.getName());
            result.setIdCard(seriesApply.getIdCard());
        }

        return result;
    }

    public void seriesApply(SeriesApplyDTO dto) {
        if (seriesBusinessMapper.checkExistUserSeriesApply(dto.getSeriesId(), dto.getSportUserId())) {
            throw new BusinessException("您已经报名当前比赛，无需重复报名");
        }

        SeriesApply seriesApply = seriesConverter.toSeriesApply(dto);
        seriesApply.setCreateTime(LocalDateTime.now());
        seriesApplyMapper.insert(seriesApply);
    }

    public SeriesQualifyingMatchHomeVO getSeriesQualifyingMatchHomeData(Long roundId, Long areaId, Long sportUserId) {
        SeriesQualifyingMatchHomeVO result = new SeriesQualifyingMatchHomeVO();
        SeriesRound seriesRound = seriesRoundMapper.selectById(roundId);
        if (seriesRound == null) {
            throw new BusinessException("当前轮次比赛不存在，请后退，重新打开当亲你赛事");
        }
        result.setChance(0);
        result.setLeftChance(0);
        result.setPath(seriesRound.getPath());
        result.setMap(seriesRound.getMap());
        result.setDistance(seriesRound.getDistance());
        result.setClimbDistance(seriesRound.getClimbDistance());
        result.setPathName(baseBusinessMapper.getMapPathName(seriesRound.getPath()));

        LocalDate today = LocalDate.now();
        LocalDate tomorrow = today.plusDays(1);
        result.setMatchList(seriesBusinessMapper
                .getSeriesQualifyingMatchList(roundId, areaId, sportUserId, today, tomorrow));

        SeriesApply apply = seriesBusinessMapper.getSeriesApply(seriesRound.getSeriesId(), sportUserId);
        if (apply != null) {
            result.setAreaId(apply.getAreaId());
            if (areaId.equals(apply.getAreaId())) {
                result.setChance(seriesRound.getChance());
                result.setLeftChance(seriesRound.getChance() - seriesBusinessMapper.getSeriesQualifyingMatchLeftChance(roundId, sportUserId));
                result.setBestResult(seriesBusinessMapper.getBestResult(roundId, sportUserId));
            }
        }

        return result;
    }


}
