package com.antai.sport.http.server.server.api.business.series.mapper;

import com.antai.sport.http.server.repository.series.entity.SeriesApply;
import com.antai.sport.http.server.server.api.business.series.vo.*;
import org.apache.ibatis.annotations.Param;

import java.time.LocalDate;
import java.util.List;

public interface SeriesBusinessMapper {

    List<SeriesListVO> getSeriesList();

    List<SeriesNoticeVO> getSeriesNotice(@Param("seriesId") Long seriesId);

    List<SeriesRoundVO> getSeriesRound(@Param("seriesId") Long seriesId);

    Boolean checkExistUserSeriesApply(@Param("seriesId") Long seriesId, @Param("sportUserId") Long sportUserId);

    List<SeriesAreaVO> getSeriesAreaList(@Param("seriesId") Long seriesId);

    SeriesApply getLatestUserSeriesApplyInfo(@Param("sportUserId") Long sportUserId);

    Integer getBestResult(@Param("roundId") Long roundId, @Param("sportUserId") Long sportUserId);

    Integer getSeriesQualifyingMatchLeftChance(@Param("roundId") Long roundId, @Param("sportUserId") Long sportUserId);

    SeriesApply getSeriesApply(@Param("seriesId") Long seriesId, @Param("sportUserId") Long sportUserId);

    List<SeriesQualifyingMatchVO> getSeriesQualifyingMatchList(@Param("roundId") Long roundId,
                                                               @Param("areaId") Long areaId,
                                                               @Param("sportUserId") Long sportUserId,
                                                               @Param("today") LocalDate today,
                                                               @Param("tomorrow") LocalDate tomorrow);
}
