package com.antai.sport.http.server.server.api.business.series.controller;

import com.antai.sport.http.server.common.base.Result;
import com.antai.sport.http.server.server.api.business.series.dto.SeriesApplyDTO;
import com.antai.sport.http.server.server.api.business.series.service.SeriesService;
import com.antai.sport.http.server.server.api.business.series.vo.SeriesApplyPreLoadVO;
import com.antai.sport.http.server.server.api.business.series.vo.SeriesDetailsVO;
import com.antai.sport.http.server.server.api.business.series.vo.SeriesListVO;
import com.antai.sport.http.server.server.api.business.series.vo.SeriesQualifyingMatchHomeVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

import static com.antai.sport.http.server.common.util.ResultUtil.success;

@RestController
@RequestMapping("series")
@Api(tags = {"系列赛接口"})
public class SeriesController {
    @Resource
    private SeriesService seriesService;

    @GetMapping("list")
    @ApiOperation(value = "查询系列赛列表")
    public ResponseEntity<Result<List<SeriesListVO>>> getSeriesList() {
        return success(seriesService.getSeriesList());
    }

    @GetMapping("{id}/{sportUserId}")
    @ApiOperation(value = "查询系列赛详情")
    public ResponseEntity<Result<SeriesDetailsVO>> getSeriesDetails(
            @PathVariable("id") Long id,
            @PathVariable("sportUserId") Long sportUserId) {
        return success(seriesService.getSeriesDetails(id, sportUserId));
    }

    @GetMapping("apply/preload/{seriesId}/{sportUserId}")
    @ApiOperation(value = "预加载报名信息方法")
    public ResponseEntity<Result<SeriesApplyPreLoadVO>> getSeresApplyPreLoadInfo(
            @PathVariable("seriesId") Long seriesId,
            @PathVariable("sportUserId") Long sportUserId) {
        return success(seriesService.getSeresApplyPreLoadInfo(sportUserId, seriesId));
    }

    @PostMapping("apply")
    @ApiOperation(value = "报名方法")
    public ResponseEntity<Result> seriesApply(@RequestBody SeriesApplyDTO dto) {
        seriesService.seriesApply(dto);
        return success();
    }

    @GetMapping("qualifying/{roundId}/{areaId}/{sportUserId}")
    @ApiOperation(value = "查询预选赛轮次主页数据")
    public ResponseEntity<Result<SeriesQualifyingMatchHomeVO>> getSeriesQualifyingMatchHomeData(
            @PathVariable("roundId") Long roundId,
            @PathVariable("areaId") Long areaId,
            @PathVariable("sportUserId") Long sportUserId) {
        return success(seriesService.getSeriesQualifyingMatchHomeData(roundId, areaId, sportUserId));
    }

}
