package com.antai.sport.http.server.repository.sys.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 字典表详情
 * </p>
 *
 * @author liming
 * @since 2021-08-23
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class SysCodeDetail implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 字典类型编号
     */
    private String typeCode;

    /**
     * 字典名称
     */
    private String name;

    /**
     * 整数类型值
     */
    private Integer valueInt;

    /**
     * 最小值范围
     */
    private BigDecimal valueMin;

    /**
     * 最大值范围
     */
    private BigDecimal valueMax;

    /**
     * 字符串类型值
     */
    private String valueStr;

    /**
     * 适用对象id 用于组织隔离权限id
     */
    private Long objectId;

    /**
     * 备注
     */
    private String remark;

    /**
     * 排序号
     */
    private Integer showOrder;

    /**
     * 删除标记
     */
    @TableLogic
    private Integer deleted;

    /**
     * 数据版本号
     */
    private Integer version;

    /**
     * 创建部门
     */
    private Long ctDeptId;

    /**
     * 创建人
     */
    private Long ctUserId;

    /**
     * 创建时间
     */
    private LocalDateTime ctDate;

    /**
     * 最后修改人
     */
    private Long lmUserId;

    /**
     * 最后修改时间
     */
    private LocalDateTime lmDate;


}
