package com.antai.sport.http.server.mobile.api.business.sport.user.dto;

import com.antai.sport.http.server.repository.sport.entity.SportUserSummary;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

@Data
@ApiModel("运动数据汇总")
public class RespSportUserSummary {

    public RespSportUserSummary() {
    }

    public RespSportUserSummary(SportUserSummary summary) {
        if (summary == null) {
            totalDistance = BigDecimal.ZERO;
            totalClimbDistance = BigDecimal.ZERO;
            totalDuration = 0;
        } else {
            totalDistance = summary.getTotalDistance();
            totalClimbDistance = summary.getTotalClimbDistance();
            totalDuration = summary.getTotalDuration();
        }
    }

    @ApiModelProperty("总骑行距离")
    private BigDecimal totalDistance;

    @ApiModelProperty("总爬坡高度")
    private BigDecimal totalClimbDistance;

    @ApiModelProperty("总持续时长")
    private Integer totalDuration;
}
