package com.antai.sport.http.server.repository.sys.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableLogic;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 字典类型表
 * </p>
 *
 * @author liming
 * @since 2021-08-23
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class SysCodeType implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 编号
     */
    private String code;

    /**
     * 名称
     */
    private String name;

    /**
     * 类型 1：系统默认 2：非系统默认
     */
    private Integer type;

    /**
     * 备用 1：全局 2：组织隔离
     */
    private Integer shareStatus;

    /**
     * 备注
     */
    private String remark;

    /**
     * 排序号
     */
    private Integer showOrder;

    /**
     * 删除标记
     */
    @TableLogic
    private Integer deleted;

    /**
     * 数据版本号
     */
    private Integer version;

    /**
     * 创建部门
     */
    private Long ctDeptId;

    /**
     * 创建人
     */
    private Long ctUserId;

    /**
     * 创建时间
     */
    private LocalDateTime ctDate;

    /**
     * 最后修改人
     */
    private Long lmUserId;

    /**
     * 最后修改时间
     */
    private LocalDateTime lmDate;


}
