package com.antai.sport.http.server.repository.match.entity;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 比赛玩家
 * </p>
 *
 * @author liming
 * @since 2021-09-11
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class MatchBicyclePlayer implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 比赛id
     */
    private Long matchId;

    /**
     * 比赛用户id
     */
    private Long userId;

    /**
     * 比赛进入时间
     */
    private LocalDateTime entryTime;

    /**
     * 比赛完成时间
     */
    private LocalDateTime finishTime;

    /**
     * 比赛用时(秒)
     */
    private Integer duration;

    /**
     * 比赛名次
     */
    private Integer matchRank;

    /**
     * 爬坡距离
     */
    private BigDecimal climbDistance;

    /**
     * 骑行总长度
     */
    private BigDecimal distance;

    /**
     * 平均功率
     */
    private BigDecimal avgFtp;

    /**
     * 平均速度
     */
    private BigDecimal avgSpeed;

    /**
     * 比赛状态1.完成比赛 2.未完成比赛
     */
    private Integer status;

    /**
     * 版本号
     */
    private Long version;

    /**
     * 删除标记
     */
    private Integer deleted;

    /**
     * 创建部门id
     */
    private Long ctDeptId;

    /**
     * 创建人id
     */
    private Long ctUserId;

    /**
     * 创建时间
     */
    private LocalDateTime ctDate;

    /**
     * 修改人id
     */
    private Long lmUserId;

    /**
     * 修改时间
     */
    private LocalDateTime lmDate;


}
