package com.antai.sport.http.server.repository.match.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 比赛信息表
 * </p>
 *
 * @author liming
 * @since 2021-09-11
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class MatchBicycle implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 比赛名称
     */
    private String name;

    /**
     * 允许进入时间
     */
    private LocalDateTime entryTime;

    /**
     * 比赛开始时间
     */
    private LocalDateTime startTime;

    /**
     * 比赛结束时间
     */
    private LocalDateTime endTime;

    /**
     * 总长度
     */
    private Integer distance;

    /**
     * 显示顺序
     */
    private Integer showOrder;

    /**
     * 版本号
     */
    private Long version;

    /**
     * 删除标记
     */
    private Integer deleted;

    /**
     * 创建部门id
     */
    private Long ctDeptId;

    /**
     * 创建人id
     */
    private Long ctUserId;

    /**
     * 创建时间
     */
    private LocalDateTime ctDate;

    /**
     * 修改人id
     */
    private Long lmUserId;

    /**
     * 修改时间
     */
    private LocalDateTime lmDate;


}
