package com.antai.sport.http.server.common.exception;

import com.antai.sport.http.server.common.base.RespCodeEnum;
import com.antai.sport.http.server.common.base.Result;
import com.antai.sport.http.server.common.util.UUIDUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;

/**
 * @Author liming
 * @Date 2021/8/20 11:37
 * @Email lmmax@126.com
 * @Description:
 */
@ControllerAdvice
@ResponseBody
public class GlobalControllerExceptionHandler {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value("${spring.profiles.active}")
    public String profile;

    @ExceptionHandler(value = Exception.class)
    public ResponseEntity<Result> businessExceptionHandler(HttpServletRequest req, Exception e, Model model) {
        String operateUser = "no-user";

        //日志打印异常
        String errorCode = UUIDUtil.createUUID().substring(0, 8);
        logger.error(operateUser + "->request:" + req.getRequestURI() + "-异常代码:" + errorCode, e);
        Result baseDTO = new Result();
        if (e instanceof BusinessException) {
            baseDTO.setRespCode(RespCodeEnum.BUSINESS_ERROR.getCode());
            baseDTO.setRespMsg(e.getMessage());
            baseDTO.setRespMsg(e.getMessage());
        } else {
            baseDTO.setRespCode(RespCodeEnum.CONTROLLER_ERROR.getCode());
            if (profile != null && profile.equals("prod")) {
                baseDTO.setRespMsg(RespCodeEnum.CONTROLLER_ERROR.getMessage());
            } else {
                baseDTO.setRespMsg(e.getMessage());
            }
        }
        baseDTO.setResultType(Result.FAIL);
        baseDTO.setErrorCode(errorCode);
        return new ResponseEntity<>(baseDTO, HttpStatus.OK);
    }
}
