package com.antai.sport.http.server.repository.sport.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 运动用户表
 * </p>
 *
 * @author liming
 * @since 2021-08-21
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class SportUser implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 手机号
     */
    private String phone;

    /**
     * 密码
     */
    private String password;

    /**
     * 昵称
     */
    private String nickname;

    /**
     * 真实名称
     */
    private String realName;

    /**
     * 生日
     */
    private LocalDateTime birthday;

    /**
     * 性别 1:男 2:女
     */
    private Integer sex;

    /**
     * 头像
     */
    private String avatar;

    /**
     * 级别
     */
    private Integer level;

    /**
     * 国家
     */
    private String country;

    /**
     * 省
     */
    private String province;

    /**
     * 市
     */
    private String city;

    /**
     * 已初始化
     */
    private Boolean initialized;

    /**
     * 备注
     */
    private String remark;

    /**
     * 排序号
     */
    private Integer showOrder;

    /**
     * 数据版本号
     */
    private Integer version;

    /**
     * 删除标记
     */
    private Integer deleted;

    /**
     * 创建时间
     */
    private LocalDateTime ctDate;

    /**
     * 最后修改人
     */
    private Integer lmUserId;

    /**
     * 最后修改时间
     */
    private LocalDateTime lmDate;


}
