package com.antai.sport.http.server.game.api.interceptor;

import com.antai.sport.http.server.common.base.Result;
import com.antai.sport.http.server.common.jwt.TokenService;
import com.antai.sport.http.server.common.jwt.TokenVO;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import io.jsonwebtoken.Claims;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

import javax.annotation.Resource;
import java.util.List;

/**
 * @Author liming
 * @Date 2021/8/22 18:07
 * @Email lmmax@126.com
 * @Description:
 */
@RestControllerAdvice(basePackages = "com.antai")
@ResponseBody
public class CustomResponseAdvice implements ResponseBodyAdvice<Object> {
    @Value("${project.header-token-key}")
    private String headerTokenKey;
    @Value("${project.jwt.subject-key}")
    private String subjectKey;
    @Value("${project.jwt.long-token-key}")
    private String longTokenKey;
    @Resource
    private TokenService tokenService;

    @Override
    public boolean supports(MethodParameter methodParameter,
                            Class<? extends HttpMessageConverter<?>> aClass) {
        return true;
    }

    @Override
    public Object beforeBodyWrite(Object result, MethodParameter methodParameter,
                                  MediaType mediaType,
                                  Class<? extends HttpMessageConverter<?>> aClass,
                                  ServerHttpRequest serverHttpRequest,
                                  ServerHttpResponse serverHttpResponse) {
        if (!(result instanceof Result)) {
            return result;
        }
        String token;
        List<String> tokenList = serverHttpRequest.getHeaders().get(headerTokenKey);
        if (tokenList != null && !tokenList.isEmpty()) {
            token = tokenList.get(0);
            if (!StringUtils.isBlank(token)) {
                Claims claims = tokenService.validateToken(token);
                if (claims != null && claims.containsKey(longTokenKey)) {
                    Result realResult = (Result) result;
                    TokenVO tokenVO = tokenService.initToken(claims.get(subjectKey).toString());
                    realResult.setRefreshToken(true);
                    realResult.setLongToken(tokenVO.getLongToken());
                    realResult.setShortToken(tokenVO.getShortToken());
                }
            }
        }
        return result;
    }
}
