package com.antai.sport.http.server.game.api.config;

import com.antai.sport.http.server.common.resolver.SportUserArgumentResolver;
import com.antai.sport.http.server.game.api.interceptor.TokenInterceptor;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

import java.util.List;

/**
 * @Author liming
 * @Date 2021/8/22 17:03
 * @Email lmmax@126.com
 * @Description:
 */
@Configuration
@ConfigurationProperties(prefix = "project")
public class WebMvcConfig implements WebMvcConfigurer {

    private List<String> permitUrl;

    @Override
    public void addCorsMappings(CorsRegistry registry) {
        registry.addMapping("/**")
                .allowedOriginPatterns("*")
                .allowCredentials(true)
                .allowedMethods("GET", "POST", "DELETE", "PUT")
                .maxAge(3600);
    }

    @Override
    public void addInterceptors(InterceptorRegistry registry) {

        registry.addInterceptor(tokenInterceptor()).
                addPathPatterns("/**").
                excludePathPatterns(permitUrl);
    }

    @Bean
    TokenInterceptor tokenInterceptor() {
        return new TokenInterceptor();
    }

    @Override
    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
        argumentResolvers.add(sportUserArgumentResolver());
    }

    @Bean
    SportUserArgumentResolver sportUserArgumentResolver() {
        return new SportUserArgumentResolver();
    }

    public void setPermitUrl(List<String> permitUrl) {
        this.permitUrl = permitUrl;
    }
}
