package com.antai.sport.http.server.game.api.business.sport.user;


import com.antai.sport.http.server.common.base.Result;
import com.antai.sport.http.server.common.exception.BusinessException;
import com.antai.sport.http.server.common.jwt.TokenService;
import com.antai.sport.http.server.common.jwt.TokenVO;
import com.antai.sport.http.server.common.service.CommonSmsService;
import com.antai.sport.http.server.common.util.RandomUtil;
import com.antai.sport.http.server.constants.DeleteStatus;
import com.antai.sport.http.server.constants.LoginMode;
import com.antai.sport.http.server.game.api.business.sport.user.dto.ReqLogin;
import com.antai.sport.http.server.repository.sport.entity.SportUser;
import com.antai.sport.http.server.repository.sport.mapper.SportUserMapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.DigestUtils;

import javax.annotation.Resource;
import java.util.List;
import java.util.concurrent.TimeUnit;

/**
 * @Author liming
 * @Date 2021/8/21 19:41
 * @Email lmmax@126.com
 * @Description:
 */
@Service
public class SportUserService {
    @Value("${spring.cache.redis.keys.login-sms-captcha}")
    private String loginSmsCaptchaRedisKey;
    @Value("${spring.cache.redis.expire.login-sms-captcha}")
    private long loginSmsCaptchaExpire;

    @Resource
    private SportUserMapper sportUserMapper;
    @Resource
    private TokenService tokenService;
    @Resource
    private CommonSmsService commonSmsService;
    @Resource
    private RedisTemplate<String, Object> redisTemplate;

    public Result login(ReqLogin param) {
        if (param.getMode() == null || (!param.getMode().equals(LoginMode.PASSWORD) && !param.getMode().equals(LoginMode.SMS_CAPTCHA))) {
            throw new BusinessException("请选择正确的登录模式");
        }
        if (StringUtils.isBlank(param.getUsername())) {
            throw new BusinessException("请输入用户名");
        }
        List<SportUser> sportUserList = sportUserMapper.selectList(new QueryWrapper<SportUser>()
                .eq("phone", param.getUsername())
                .eq("deleted", DeleteStatus.UNDELETED));
        if (sportUserList.isEmpty()) {
            throw new BusinessException("用户名或密码错误");
        }
        SportUser sportUser = sportUserList.get(0);

        Result result = new Result();
        if (param.getMode().equals(LoginMode.PASSWORD)) {
            if (sportUser.getPassword() == null) {
                throw new BusinessException("当前用户还没有设置密码，请使用验证码方式登录");
            }
            if (StringUtils.isBlank(param.getPassword())) {
                throw new BusinessException("请输入密码");
            }
            String hashPwd = DigestUtils.md5DigestAsHex(param.getPassword().getBytes());
            if (!hashPwd.equals(sportUser.getPassword())) {
                throw new BusinessException("用户名或密码错误");
            }
        } else {
            if (StringUtils.isBlank(param.getSmsCaptcha())) {
                throw new BusinessException("请输入验证码");
            }
            String redisKey = loginSmsCaptchaRedisKey + param.getUsername();
            Object redisValue = redisTemplate.opsForValue().get(redisKey);
            if (redisValue == null) {
                throw new BusinessException("请先获取验证码");
            }
            String loginSmsCaptcha = redisValue.toString();
            if (!loginSmsCaptcha.equals(param.getSmsCaptcha())) {
                throw new BusinessException("短信验证码错误");
            }
            redisTemplate.delete(redisKey);
        }
        result.setRespMsg("登录成功");
        TokenVO tokenVO = tokenService.initToken(param.getUsername());
        result.setLongToken(tokenVO.getLongToken());
        result.setShortToken(tokenVO.getShortToken());
        result.setData(true);
        return result;
    }

    /**
     * 发送验证码逻辑
     * @param phone 电话号码
     */
    public void sendLoginSmsCaptcha(String phone) {
        String code = String.valueOf(RandomUtil.generateNum());
        commonSmsService.sendLoginSmsCaptcha(phone, code);
        redisTemplate.opsForValue().set(loginSmsCaptchaRedisKey + phone, code, loginSmsCaptchaExpire, TimeUnit.SECONDS);
    }

}
