package com.antai.sport.http.server.game.api.business.sport.user;

import com.antai.sport.http.server.common.base.Result;
import com.antai.sport.http.server.game.api.business.sport.user.dto.ReqLogin;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;

import static com.antai.sport.http.server.common.base.Result.success;

/**
 * @Author liming
 * @Date 2021/8/21 19:41
 * @Email lmmax@126.com
 * @Description:
 */
@RestController
@Api(tags = {"用户相关接口"})
public class SportUserController {

    @Resource
    private SportUserService sportUserService;

    @ApiOperation(value = "登录接口", notes = "登录成功后返回长短token")
    @PostMapping("/login")
    public ResponseEntity<Result> login(@RequestBody ReqLogin param) {
        return success(sportUserService.login(param));
    }

    @ApiOperation(value = "获取登录短信验证码")
    @GetMapping("/login/sms/captcha/{phone}")
    public ResponseEntity<Result> sendLoginSmsCaptcha(@PathVariable String phone) {
        sportUserService.sendLoginSmsCaptcha(phone);
        return success(true);
    }
}
