package com.antai.sport.http.server.common.base;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;

import java.util.ArrayList;
import java.util.List;

/**
 * @Author liming
 * @Date 2021/8/20 11:19
 * @Email lmmax@126.com
 * @Description:
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class Result {

    public final static Integer SUCCESS = 1;
    public final static Integer FAIL = 2;

    private Integer resultType = SUCCESS;
    private String respCode;
    private String respMsg;
    private String errorCode;
    private Object data;
    private boolean refreshToken;
    private String longToken;
    private String shortToken;

    public static ResponseEntity<Result> error(RespCodeEnum RespCodeEnum) {
        Result Result = new Result();
        Result.setRespCode(RespCodeEnum.getCode());
        Result.setRespMsg(RespCodeEnum.getMessage());
        Result.setResultType(FAIL);
        return new ResponseEntity<>(Result, HttpStatus.OK);
    }

    public static ResponseEntity<Result> error(RespCodeEnum RespCodeEnum, String errorMsg) {
        Result Result = new Result();
        Result.setRespCode(RespCodeEnum.getCode());
        Result.setRespMsg(errorMsg);
        Result.setResultType(FAIL);
        return new ResponseEntity<>(Result, HttpStatus.OK);
    }

    public static ResponseEntity<Result> error(RespCodeEnum RespCodeEnum, BindingResult bindingResult) {
        Result Result = new Result();
        Result.setRespCode(RespCodeEnum.getCode());
        Result.setRespMsg(RespCodeEnum.getMessage());
        Result.setResultType(FAIL);
        StringBuilder errorStr = new StringBuilder();
        List<String> errorList = new ArrayList<>();
        for (int i = 0; i < bindingResult.getErrorCount(); i++) {
            ObjectError oe = bindingResult.getAllErrors().get(i);
            errorList.add(oe.getDefaultMessage());
            if (i == 0) {
                errorStr.append(oe.getDefaultMessage());
            } else {
                errorStr.append(",").append(oe.getDefaultMessage());
            }
        }
        Result.setData(errorStr.toString());
        return new ResponseEntity<>(Result, HttpStatus.OK);
    }

    public static ResponseEntity<Result> success(HttpHeaders httpHeaders, Object object) {
        Result Result = new Result();
        Result.setRespCode(RespCodeEnum.SUCCESS.getCode());
        Result.setRespMsg(RespCodeEnum.SUCCESS.getMessage());
        Result.setData(object);
        Result.setResultType(SUCCESS);
        return new ResponseEntity<>(Result, httpHeaders, HttpStatus.OK);
    }


    public static ResponseEntity<Result> success(Object object) {
        Result Result = new Result();
        Result.setRespCode(RespCodeEnum.SUCCESS.getCode());
        Result.setRespMsg(RespCodeEnum.SUCCESS.getMessage());
        Result.setData(object);
        Result.setResultType(SUCCESS);
        return new ResponseEntity<>(Result, new HttpHeaders(), HttpStatus.OK);
    }

    public static ResponseEntity<Result> success(Result result) {
        result.setRespCode(RespCodeEnum.SUCCESS.getCode());
        result.setResultType(SUCCESS);
        return new ResponseEntity<>(result, new HttpHeaders(), HttpStatus.OK);
    }
}
