package com.antai.sport.http.server.server.api.business.user.service;

import com.antai.sport.http.server.constants.SportType;
import com.antai.sport.http.server.repository.sport.entity.SportUser;
import com.antai.sport.http.server.repository.sport.entity.SportUserSummary;
import com.antai.sport.http.server.repository.sport.entity.SportUserTrainingLog;
import com.antai.sport.http.server.repository.sport.mapper.SportUserMapper;
import com.antai.sport.http.server.server.api.business.traininglog.service.SportUserTrainingLogService;
import com.antai.sport.http.server.server.api.business.user.dto.RespUserHomeInfo;
import com.antai.sport.http.server.server.api.business.traininglog.dto.SportUserTrainingLogSummaryVO;
import com.antai.sport.http.server.server.api.business.user.mapper.SportUserSummaryBusinessMapper;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.math.RoundingMode;

@Service
public class SportUserService {
    @Resource
    private SportUserMapper sportUserMapper;

    @Resource
    private SportUserSummaryBusinessMapper sportUserSummaryBusinessMapper;

    @Resource
    private SportUserTrainingLogService sportUserTrainingLogService;

    public RespUserHomeInfo getUserHomeInfo(Long userId) {
        RespUserHomeInfo resp = new RespUserHomeInfo();
        SportUser sportUser = sportUserMapper.selectById(userId);
        SportUserSummary sportUserSummary = sportUserSummaryBusinessMapper.selectBySportTypeAndUserId(userId, SportType.BICYCLE);
        if(sportUserSummary == null){
            sportUserSummary = new SportUserSummary();
            sportUserSummary.setViews(0);
            sportUserSummary.setTotalDistance(BigDecimal.ZERO);
            sportUserSummary.setTotalClimbDistance(BigDecimal.ZERO);
            sportUserSummary.setTotalDuration(0);
        }
        resp.setId(sportUser.getId());
        resp.setAvatar(sportUser.getAvatar());
        resp.setNickname(sportUser.getNickname());
        resp.setViews(sportUserSummary.getViews() == null ? 0 : sportUserSummary.getViews());
        resp.setFtp(sportUser.getFtp() == null ? 0 : sportUser.getFtp());

        if (sportUser.getFtp() == null || sportUser.getWeight() == null) {
            resp.setWkg(BigDecimal.ZERO);
        } else {
            resp.setWkg(BigDecimal.valueOf(sportUser.getFtp()).divide(sportUser.getWeight(), 1, RoundingMode.HALF_UP));
        }

        //组装全部汇总数据
        SportUserTrainingLogSummaryVO totalSummary = new SportUserTrainingLogSummaryVO();
        totalSummary.setTotalDistance(sportUserSummary.getTotalDistance());
        totalSummary.setTotalClimbDistance(sportUserSummary.getTotalClimbDistance());
        totalSummary.setTotalDuration(sportUserSummary.getTotalDuration());
        SportUserTrainingLog longestTrainingLog = sportUserTrainingLogService.getLongestTrainingLog(SportType.BICYCLE, userId);
        if(longestTrainingLog == null){
            totalSummary.setLongestDistance(BigDecimal.ZERO);
        } else {
            totalSummary.setLongestDistance(longestTrainingLog.getDistance());
        }
        resp.setTotalSummary(totalSummary);
        //查询7天数据汇总
        resp.setWeekSummary(sportUserTrainingLogService.getTrainingLogSummary(SportType.BICYCLE,userId,7));
        //查询30天数据汇总
        resp.setMonthSummary(sportUserTrainingLogService.getTrainingLogSummary(SportType.BICYCLE,userId,30));

        return resp;
    }
}
