package com.antai.sport.http.server.repository.sport.entity;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 
 * </p>
 *
 * @author liming
 * @since 2022-04-12
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class SportUserTrainingLog implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 比赛类型 1:自行车 2:跑步
     */
    private Integer sportType;

    /**
     * 比赛模式  10:漫游 20:日常赛 30:系列赛 40:训练模式 50: 团练 60:娱乐赛
     */
    private Integer gameMode;

    /**
     * 玩家id
     */
    private Long playerId;

    /**
     * 源头id 比如娱乐房间id 赛事id等
     */
    private Long sourceId;

    /**
     * 运动记录id
     */
    private Long recordId;

    /**
     * 地图key
     */
    private String map;

    /**
     * 赛道key
     */
    private String path;

    /**
     * 卡路里
     */
    private Integer calorie;

    /**
     * 比赛用时(秒)
     */
    private Integer duration;

    /**
     * 比赛名次
     */
    private Integer matchRank;

    /**
     * 骑行总长度
     */
    private BigDecimal distance;

    /**
     * 爬坡距离
     */
    private BigDecimal climbDistance;

    /**
     * 平均功率
     */
    private BigDecimal avgFtp;

    /**
     * 平均速度
     */
    private BigDecimal avgSpeed;

    /**
     * 获攒数量
     */
    private Integer praiseNum;

    /**
     * 创建日期不带时分秒
     */
    private LocalDate createDate;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;


}
