package com.antai.sport.http.server.repository.sport.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 用户选装部位皮肤
 * </p>
 *
 * @author liming
 * @since 2021-08-23
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class SportSectionSkin implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 性别
     */
    private Integer sex;

    /**
     * 类型 1.身体部位 2.设备
     */
    private Integer type;

    /**
     * 部位
     */
    private Long section;

    /**
     * 名称
     */
    private String name;

    /**
     * 游戏中的标识
     */
    private String skinKey;

    /**
     * 备注
     */
    private String remark;

    /**
     * 排序号
     */
    private Integer showOrder;

    /**
     * 删除标记
     */
    @TableLogic
    private Integer deleted;

    /**
     * 数据版本号
     */
    private Integer version;

    /**
     * 创建人
     */
    private Long ctUserId;

    /**
     * 创建时间
     */
    private LocalDateTime ctDate;

    /**
     * 最后修改人
     */
    private Long lmUserId;

    /**
     * 最后修改时间
     */
    private LocalDateTime lmDate;


}
