package com.antai.sport.http.server.mobile.api.business.match.bicycle.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @Author liming
 * @Date 2021/9/11 19:48
 * @Email lmmax@126.com
 * @Description:
 */
@Data
@ApiModel("比赛结果")
public class DtoMatchBicycleResult {
    @ApiModelProperty("比赛id")
    private Long matchId;
    @ApiModelProperty("用户id")
    private Long userId;
    @ApiModelProperty("用户昵称")
    private String nickname;
    @ApiModelProperty("进入时间 yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime entryTime;
    @ApiModelProperty("完成时间 yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime finishTime;
    @ApiModelProperty("比赛用时(秒)")
    private Integer duration;
    @ApiModelProperty("比赛名次")
    private Integer matchRank;
    @ApiModelProperty("骑行总长度")
    private BigDecimal distance;
    @ApiModelProperty("爬坡高度")
    private BigDecimal climbDistance;
    @ApiModelProperty("平均功率")
    private BigDecimal avgFtp;
    @ApiModelProperty("平均速度")
    private BigDecimal avgSpeed;
    @ApiModelProperty("比赛状态1.完成比赛 2.未完成比赛")
    private Integer status;

}
