package com.antai.sport.http.server.mobile.api.business.match.bicycle.controller;

import com.antai.sport.http.server.mobile.api.business.match.bicycle.dto.DtoMatchBicycleResult;
import com.antai.sport.http.server.mobile.api.business.match.bicycle.dto.ReqMatchBicycleSave;
import com.antai.sport.http.server.mobile.api.business.match.bicycle.dto.RespMatchBicycleList;
import com.antai.sport.http.server.mobile.api.business.match.bicycle.service.MatchBicyclePlayerService;
import com.antai.sport.http.server.mobile.api.business.match.bicycle.service.MatchBicycleService;
import com.antai.sport.http.server.common.annotation.LoginSportUser;
import com.antai.sport.http.server.common.base.Result;
import com.antai.sport.http.server.mobile.api.business.match.bicycle.dto.DtoMatchAutoCreate;
import com.antai.sport.http.server.repository.sport.entity.SportUser;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

import static com.antai.sport.http.server.common.util.ResultUtil.success;

/**
 * @Author liming
 * @Date 2021/9/11 18:31
 * @Email lmmax@126.com
 * @Description:
 */
@RestController()
@RequestMapping("/match/bicycle")
@Api(tags = {"比赛相关接口"})
public class MatchBicycleController {
    @Resource
    private MatchBicycleService matchBicycleService;
    @Resource
    private MatchBicyclePlayerService matchBicyclePlayerService;

    @PostMapping
    @ApiOperation(value = "创建比赛", notes = "data 为创建成功的比赛Id")
    public ResponseEntity<Result<Long>> saveMatchBicycle(@RequestBody ReqMatchBicycleSave data) {
        return success(matchBicycleService.saveMatchBicycle(data));
    }

    @GetMapping()
    @ApiOperation(value = "获取比赛列表接口", notes = "data为比赛列表数据")
    public ResponseEntity<Result<List<RespMatchBicycleList>>> getMatchBicycleList() {
        return success(matchBicycleService.getMatchBicycleList());
    }

    @DeleteMapping("/{matchId}")
    @ApiOperation(value = "删除比赛接口" )
    public ResponseEntity<Result> deleteMatchBicycle(@PathVariable Long matchId) {
        matchBicycleService.removeById(matchId);
        return success();
    }

    @PostMapping("/entry/{matchId}")
    @ApiOperation(value = "加入比赛接口")
    public ResponseEntity<Result> entryMatchBicycle(@LoginSportUser SportUser loginUser, @PathVariable Long matchId) {
        matchBicycleService.entryMatchBicycle(loginUser, matchId);
        return success();
    }

    @PostMapping("/player/record")
    @ApiOperation(value = "比赛数据保存")
    public ResponseEntity<Result> saveMatchBicyclePlayerRecord(@RequestBody List<DtoMatchBicycleResult> resultList) {
        matchBicyclePlayerService.saveMatchBicyclePlayerRecord(resultList);
        return success();
    }

    @GetMapping("/player/record/{matchId}")
    @ApiOperation(value = "比赛数据查询")
    public ResponseEntity<Result<List<DtoMatchBicycleResult>>> getMatchBicyclePlayerRecord(@PathVariable Long matchId) {
        return success(matchBicyclePlayerService.getMatchBicyclePlayerRecord(matchId));
    }

    /**
     * 自动结束当前比赛并且重新开启一场比赛
     */
    @PostMapping("/auto/create")
    @ApiOperation(value = "自动关闭当前赛事，创建一个新的比赛",
            notes = "创建比赛规则：进入时间=当前时间+1分钟 开始时间=进入时间+1分钟 结束时间=开始时间+20分钟")
    public ResponseEntity<Result> autoCreate(@RequestBody DtoMatchAutoCreate param){
        matchBicycleService.autoCreate(param);
        return success();
    }
}
