package com.antai.sport.http.server.server.api.business.tour.service;

import com.antai.sport.http.server.constants.GameMode;
import com.antai.sport.http.server.constants.SportType;
import com.antai.sport.http.server.constants.TourRecordStatus;
import com.antai.sport.http.server.repository.tour.entity.TourRecord;
import com.antai.sport.http.server.repository.tour.mapper.TourRecordMapper;
import com.antai.sport.http.server.server.api.business.praise.service.PraiseService;
import com.antai.sport.http.server.server.api.business.tour.converter.TourRecordConverter;
import com.antai.sport.http.server.server.api.business.tour.dto.ReqTourRecordInit;
import com.antai.sport.http.server.server.api.business.tour.dto.RespTourRecordInit;
import com.antai.sport.http.server.server.api.common.dto.CyclingDataDTO;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.List;

@Service
public class TourService {

    @Resource
    private TourRecordMapper tourRecordMapper;

    @Resource
    private TourRecordConverter tourRecordConverter;

    @Resource
    private PraiseService praiseService;

    /**
     * 初始化漫游记录
     *
     * @param initData
     * @return
     */
    public RespTourRecordInit init(ReqTourRecordInit initData) {
        RespTourRecordInit resp = new RespTourRecordInit();
        TourRecord tourRecord = new TourRecord();
        tourRecord.setPlayerId(initData.getPlayerId());
        tourRecord.setMap(initData.getMap());
        tourRecord.setPath(initData.getPath());
        tourRecord.setCreateTime(LocalDateTime.now());
        tourRecord.setStatus(TourRecordStatus.UNCOMMITTED);
        tourRecordMapper.insert(tourRecord);

        resp.setRecordId(tourRecord.getId());
        resp.setSportType(SportType.BICYCLE);
        resp.setGameMode(GameMode.TOUR);
        return resp;
    }

    /**
     * 上传漫游记录
     *
     * @param tourRecordList
     */
    public void upload(List<CyclingDataDTO> tourRecordList) {
        tourRecordList.forEach(item -> {
            TourRecord tourRecord = tourRecordConverter.convertToTourRecord(item, TourRecordStatus.COMMITTED);
            tourRecord.setPraiseNum(praiseService.getPraiseByGameModeAndRecordId(GameMode.TOUR, item.getRecordId()));
            tourRecordMapper.updateById(tourRecord);
        });
    }
}
