package com.antai.sport.http.server.repository.train.entity;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 跑步训练运动记录
 * </p>
 *
 * @author liming
 * @since 2021-09-26
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class TrainRunRecord implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 训练类型 1.漫游骑行 2.课程训练
     */
    private Integer type;

    /**
     * 用户id
     */
    private Long userId;

    /**
     * 开始时间
     */
    private LocalDateTime startTime;

    /**
     * 结束时间
     */
    private LocalDateTime endTime;

    /**
     * 骑行时长（秒）
     */
    private Integer duration;

    /**
     * 爬坡距离
     */
    private BigDecimal climbDistance;

    /**
     * 骑行总长度
     */
    private BigDecimal distance;

    /**
     * 平均速度
     */
    private BigDecimal avgSpeed;

    /**
     * 配速
     */
    private BigDecimal pace;

    /**
     * 版本号
     */
    private Long version;

    /**
     * 删除标记
     */
    private Integer deleted;

    /**
     * 创建时间
     */
    private LocalDateTime ctDate;

    /**
     * 修改人id
     */
    private Long lmUserId;

    /**
     * 修改时间
     */
    private LocalDateTime lmDate;


}
