package com.antai.sport.http.server.repository.tour.entity;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 
 * </p>
 *
 * @author liming
 * @since 2022-04-11
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class TourRecord implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 用户id
     */
    private Long playerId;

    /**
     * 地图
     */
    private String map;

    /**
     * 赛道
     */
    private String path;

    /**
     * 骑行时长（秒）
     */
    private Integer duration;

    /**
     * 骑行总长度
     */
    private BigDecimal distance;

    /**
     * 爬坡距离
     */
    private BigDecimal climbDistance;

    /**
     * 平均功率
     */
    private BigDecimal avgFtp;

    /**
     * 平均速度
     */
    private BigDecimal avgSpeed;

    /**
     * 获攒数量
     */
    private Integer praiseNum;

    /**
     * 状态 10.未提交数据 20.已提交数据
     */
    private Integer status;

    /**
     * 版本号
     */
    private Long version;

    /**
     * 删除标记
     */
    private Integer deleted;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 修改时间
     */
    private LocalDateTime updateTime;


}
