package com.antai.sport.http.server.repository.sport.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 运动用户表
 * </p>
 *
 * @author liming
 * @since 2021-08-23
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class SportUser implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 手机号
     */
    private String phone;

    /**
     * 密码
     */
    private String password;

    /**
     * 昵称
     */
    private String nickname;

    /**
     * 真实名称
     */
    private String realName;

    /**
     * 生日
     */
    private LocalDateTime birthday;

    /**
     * 性别 1:男 2:女
     */
    private Integer sex;

    /**
     * 身高
     */
    private BigDecimal height;

    /**
     * 体重
     */
    private BigDecimal weight;

    /**
     * ftp
     */
    private Integer ftp;

    /**
     * 头像
     */
    private String avatar;

    /**
     * 级别
     */
    private Integer level;

    /**
     * 国家
     */
    private String country;

    /**
     * 省
     */
    private String province;

    /**
     * 市
     */
    private String city;

    /**
     * 初始化个人信息
     */
    private Boolean infoInitialized;

    /**
     * 初始化接角色
     */
    private Boolean roleInitialized;

    /**
     * 设备初始化
     */
    private Boolean equipmentInitialized;

    /**
     * 备注
     */
    private String remark;

    /**
     * 排序号
     */
    private Integer showOrder;

    /**
     * 数据版本号
     */
    private Integer version;

    /**
     * 删除标记
     */
    @TableLogic
    private Integer deleted;

    /**
     * 创建时间
     */
    private LocalDateTime ctDate;

    /**
     * 最后修改人
     */
    private Integer lmUserId;

    /**
     * 最后修改时间
     */
    private LocalDateTime lmDate;


}
