package com.antai.sport.http.server.repository.simplematch.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 
 * </p>
 *
 * @author liming
 * @since 2022-04-11
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class SimpleMatch implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 比赛名称
     */
    private String name;

    /**
     * logo
     */
    private String logo;

    /**
     * 地图key
     */
    private String map;

    /**
     * 赛道key
     */
    private String path;

    /**
     * 允许进入时间
     */
    private LocalDateTime entryTime;

    /**
     * 比赛开始时间
     */
    private LocalDateTime startTime;

    /**
     * 比赛结束时间
     */
    private LocalDateTime endTime;

    /**
     * 总长度
     */
    private BigDecimal distance;

    /**
     * 爬坡高度
     */
    private BigDecimal climbDistance;

    /**
     * 描述
     */
    private String description;

    /**
     * 显示顺序
     */
    private Integer showOrder;

    /**
     * 版本号
     */
    private Long version;

    /**
     * 删除标记
     */
    private Integer deleted;

    /**
     * 创建人
     */
    private Long createBy;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 修改人
     */
    private Long updateBy;

    /**
     * 修改时间
     */
    private LocalDateTime updateTime;


}
