package com.antai.sport.http.server.repository.roommode.entity;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 
 * </p>
 *
 * @author liming
 * @since 2022-04-11
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class RoomMode implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 房间名称
     */
    private String name;

    /**
     * 地图名称
     */
    private String map;

    /**
     * 路线名称
     */
    private String path;

    /**
     * 距离
     */
    private BigDecimal distance;

    /**
     * 爬坡高度
     */
    private BigDecimal climbDistance;

    /**
     * 玩家数量
     */
    private Integer playerNum;

    /**
     * 是否公开房间 0:不公开 1:公开
     */
    private Boolean publicStatus;

    /**
     * 模式: 10:竞速模式 2:道具模式
     */
    private Integer mode;

    /**
     * 状态 10:未结束 20:已结束
     */
    private Integer status;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 修改时间
     */
    private LocalDateTime updateTime;


}
