package com.antai.sport.http.server.mobile.api.business.sport.user.dto;

import com.antai.sport.http.server.repository.sport.entity.SportUser;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @Author liming
 * @Date 2021/8/23 15:21
 * @Email lmmax@126.com
 * @Description:
 */
@Data
public class RespBaseUserInfo {
    private static final long serialVersionUID = 1L;

    public RespBaseUserInfo(SportUser sportUser) {
        phone = sportUser.getPhone();
        nickname = sportUser.getNickname();
        realName = sportUser.getRealName();
        birthday = sportUser.getBirthday();
        sex = sportUser.getSex();
        height = sportUser.getHeight();
        weight = sportUser.getWeight();
        avatar = sportUser.getAvatar();
        country = sportUser.getCountry();
        province = sportUser.getProvince();
        city = sportUser.getCity();
        infoInitialized = sportUser.getInfoInitialized();
        roleInitialized = sportUser.getRoleInitialized();
        equipmentInitialized = sportUser.getEquipmentInitialized();
    }

    @ApiModelProperty(value = "手机号")
    private String phone;

    @ApiModelProperty(value = "昵称")
    private String nickname;

    @ApiModelProperty(value = "真实名称")
    private String realName;

    @ApiModelProperty(value = "生日")
    private LocalDateTime birthday;

    @ApiModelProperty(value = "性别 1:男 2:女")
    private Integer sex;

    @ApiModelProperty(value = "身高")
    private BigDecimal height;

    @ApiModelProperty(value = "体重")
    private BigDecimal weight;

    @ApiModelProperty(value = "头像")
    private String avatar;

    @ApiModelProperty(value = "国家")
    private String country;

    @ApiModelProperty(value = "省")
    private String province;

    @ApiModelProperty(value = "市")
    private String city;

    @ApiModelProperty(value = "是否已经初始化个人信息")
    private Boolean infoInitialized;

    @ApiModelProperty(value = "是否已经初始化接角色")
    private Boolean roleInitialized;

    @ApiModelProperty(value = "是否已经初始化设备")
    private Boolean equipmentInitialized;

    @ApiModelProperty(value = "骑行数据汇总")
    private RespSportUserSummary bicycleSummary;

    @ApiModelProperty(value = "跑步数据汇总")
    private RespSportUserSummary runSummary;
}
