package com.antai.sport.http.server.mobile.api.business.match.bicycle.service;

import com.antai.sport.http.server.common.exception.BusinessException;
import com.antai.sport.http.server.constants.DeleteStatus;
import com.antai.sport.http.server.mobile.api.business.match.bicycle.mapper.MatchBicycleBusinessMapper;
import com.antai.sport.http.server.mobile.api.business.match.bicycle.dto.DtoMatchAutoCreate;
import com.antai.sport.http.server.mobile.api.business.match.bicycle.dto.ReqMatchBicycleSave;
import com.antai.sport.http.server.mobile.api.business.match.bicycle.dto.RespMatchBicycleList;
import com.antai.sport.http.server.repository.match.entity.MatchBicycle;
import com.antai.sport.http.server.repository.match.mapper.MatchBicycleMapper;
import com.antai.sport.http.server.repository.sport.entity.SportUser;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @Author liming
 * @Date 2021/9/11 18:32
 * @Email lmmax@126.com
 * @Description:
 */
@Service
public class MatchBicycleService extends ServiceImpl<MatchBicycleMapper, MatchBicycle> {
    @Resource
    private MatchBicycleBusinessMapper matchBicycleBusinessMapper;
    @Value("${game-server-address}")
    private String gameServerAddress;

    public Long saveMatchBicycle(@RequestBody ReqMatchBicycleSave data) {
        if (StringUtils.isBlank(data.getName())) {
            throw new BusinessException("比赛名称不能为空");
        }

        if (data.getEntryTime() == null || data.getStartTime() == null || data.getEndTime() == null) {
            throw new BusinessException("所有输入时间不能为空");
        }

        if (data.getEntryTime().equals(data.getStartTime()) || data.getEntryTime().isAfter(data.getStartTime())) {
            throw new BusinessException("允许进入时间必须早于比赛开始时间");
        }

        if (data.getStartTime().equals(data.getEndTime()) || data.getStartTime().isAfter(data.getEndTime())) {
            throw new BusinessException("比赛开始时间必须早于比赛结束时间");
        }

        if (matchBicycleBusinessMapper.checkMatchRepeat(data.getEntryTime(), data.getEndTime())) {
            throw new BusinessException("比赛时间段有冲突，请修改比赛时间");
        }

        MatchBicycle match = new MatchBicycle();
        match.setName(data.getName());
        match.setEntryTime(data.getEntryTime());
        match.setStartTime(data.getStartTime());
        match.setEndTime(data.getEndTime());
        match.setDistance(data.getDistance());
        this.save(match);
        return match.getId();
    }

    public List<RespMatchBicycleList> getMatchBicycleList() {
        return matchBicycleBusinessMapper.getMatchBicycleList();
    }

    public void entryMatchBicycle(SportUser loginUser, Long matchId) {
        MatchBicycle match = this.getById(matchId);
        if (match == null || match.getEndTime() == null) {
            throw new BusinessException("您报名的比赛不存在");
        }

        LocalDateTime now = LocalDateTime.now();
        if (now.isBefore(match.getEntryTime())) {
            throw new BusinessException("当前比赛还没到进入时间，请查看比赛详情");
        }
        if (now.isAfter(match.getEndTime())) {
            throw new BusinessException("当前比赛已经结束，您已无法参加");
        }
        if (now.isAfter(match.getStartTime())) {
            throw new BusinessException("当前比赛已经开始，您已无法加入");
        }
    }

    public void autoCreate(DtoMatchAutoCreate param) {
        //查询当前进行中的比赛进行,设置结束时间为当前时间
        QueryWrapper<MatchBicycle> matchQuery = new QueryWrapper<>();
        LocalDateTime now = LocalDateTime.now();
        matchQuery.eq("deleted", DeleteStatus.UNDELETED).ge("end_time", now);
        List<MatchBicycle> matchList = this.list(matchQuery);
        if (matchList != null && matchList.size() > 0) {
            for (MatchBicycle item : matchList) {
                item.setEndTime(now);
                item.setStartTime(now);
            }
            this.saveOrUpdateBatch(matchList);
        }
        //调用游戏服务端的暂停接口
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.getForObject(gameServerAddress,String.class);

        //创建一场新的比赛 创建比赛规则：进入时间=当前时间+1分钟 开始时间=进入时间+1分钟 结束时间=开始时间+20分钟
        MatchBicycle match = new MatchBicycle();
        match.setName(param.getName());
        match.setEntryTime(now.plusMinutes(param.getDelayEntryMinute()));
        match.setStartTime(now.plusMinutes(param.getDelayEntryMinute() + param.getWarmUpMinute()));
        match.setEndTime(now.plusMinutes(param.getDelayEntryMinute() + param.getWarmUpMinute() + param.getMatchMinute()));
        match.setDistance(param.getDistance());
        this.save(match);

    }
}
