package com.antai.sport.http.server.server.api.business.user.service;

import com.antai.sport.http.server.constants.SportType;
import com.antai.sport.http.server.repository.sport.entity.*;
import com.antai.sport.http.server.repository.sport.mapper.SportUserContinuousLoginDaysMapper;
import com.antai.sport.http.server.repository.sport.mapper.SportUserLoginLogMapper;
import com.antai.sport.http.server.repository.sport.mapper.SportUserMapper;
import com.antai.sport.http.server.server.api.business.achievement.service.AchievementService;
import com.antai.sport.http.server.server.api.business.traininglog.dto.SportUserTrainingLogSummaryVO;
import com.antai.sport.http.server.server.api.business.traininglog.service.SportUserTrainingLogService;
import com.antai.sport.http.server.server.api.business.user.dto.NewMessageVO;
import com.antai.sport.http.server.server.api.business.user.dto.RespUserHomeInfo;
import com.antai.sport.http.server.server.api.business.user.mapper.SportUserSummaryBusinessMapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;

@Service
public class SportUserService {
    @Resource
    private SportUserMapper sportUserMapper;
    @Resource
    private SportUserLoginLogMapper sportUserLoginLogMapper;
    @Resource
    private SportUserContinuousLoginDaysMapper sportUserContinuousLoginDaysMapper;


    @Resource
    private SportUserSummaryBusinessMapper sportUserSummaryBusinessMapper;

    @Resource
    private SportUserTrainingLogService sportUserTrainingLogService;
    @Resource
    private AchievementService achievementService;

    public RespUserHomeInfo getUserHomeInfo(Long userId) {
        RespUserHomeInfo resp = new RespUserHomeInfo();
        SportUser sportUser = sportUserMapper.selectById(userId);
        SportUserSummary sportUserSummary = sportUserSummaryBusinessMapper.selectBySportTypeAndUserId(userId,
                SportType.BICYCLE);
        if (sportUserSummary == null) {
            sportUserSummary = new SportUserSummary();
            sportUserSummary.setViews(0);
            sportUserSummary.setTotalDistance(BigDecimal.ZERO);
            sportUserSummary.setTotalClimbDistance(BigDecimal.ZERO);
            sportUserSummary.setTotalDuration(0);
            sportUserSummary.setTotalCalorie(0);
        }
        resp.setId(sportUser.getId());
        resp.setAvatar(sportUser.getAvatar());
        resp.setNickname(sportUser.getNickname());
        resp.setViews(sportUserSummary.getViews() == null ? 0 : sportUserSummary.getViews());
        resp.setFtp(sportUser.getFtp() == null ? 0 : sportUser.getFtp());
        resp.setProvinceName(sportUser.getProvinceName());
        resp.setCityName(sportUser.getCityName());

        if (sportUser.getFtp() == null || sportUser.getWeight() == null) {
            resp.setWkg(BigDecimal.ZERO);
        } else {
            resp.setWkg(BigDecimal.valueOf(sportUser.getFtp()).divide(sportUser.getWeight(), 1, RoundingMode.HALF_UP));
        }

        //组装全部汇总数据
        SportUserTrainingLogSummaryVO totalSummary = new SportUserTrainingLogSummaryVO();
        totalSummary.setTotalDistance(sportUserSummary.getTotalDistance());
        totalSummary.setTotalClimbDistance(sportUserSummary.getTotalClimbDistance());
        totalSummary.setTotalDuration(sportUserSummary.getTotalDuration());
        totalSummary.setCalorie(sportUserSummary.getTotalCalorie());
        SportUserTrainingLog longestTrainingLog = sportUserTrainingLogService.getLongestTrainingLog(SportType.BICYCLE
                , userId);
        if (longestTrainingLog == null) {
            totalSummary.setLongestDistance(BigDecimal.ZERO);
        } else {
            totalSummary.setLongestDistance(longestTrainingLog.getDistance());
        }
        resp.setTotalSummary(totalSummary);
        //查询7天数据汇总
        resp.setWeekSummary(sportUserTrainingLogService.getTrainingLogSummary(SportType.BICYCLE, userId, 7));
        //查询30天数据汇总
        resp.setMonthSummary(sportUserTrainingLogService.getTrainingLogSummary(SportType.BICYCLE, userId, 30));

        return resp;
    }

    /**
     * 用户登录日志
     */
    public void signIn(Long sportUserId) {
        //插入登录日志
        SportUserLoginLog loginLog = new SportUserLoginLog();
        loginLog.setSportUserId(sportUserId);
        loginLog.setCreateTime(LocalDateTime.now());
        sportUserLoginLogMapper.insert(loginLog);

        //查询连续登录时间
        QueryWrapper<SportUserContinuousLoginDays> continuousLoginDaysQuery = new QueryWrapper<>();
        continuousLoginDaysQuery.lambda().eq(SportUserContinuousLoginDays::getSportUserId, sportUserId);
        SportUserContinuousLoginDays continuousLoginDays =
                sportUserContinuousLoginDaysMapper.selectOne(continuousLoginDaysQuery);
        if (continuousLoginDays == null) {
            continuousLoginDays = new SportUserContinuousLoginDays();
            continuousLoginDays.setDays(1);
            continuousLoginDays.setSportUserId(sportUserId);
            continuousLoginDays.setLastLoginDate(LocalDate.now());
            sportUserContinuousLoginDaysMapper.insert(continuousLoginDays);
            return;
        }
        //当最近连续登录时间相同时不做处理
        if (continuousLoginDays.getLastLoginDate().isEqual(LocalDate.now())) {
            return;
        }
        //当最近连续登录时间和当天时间间隔一天时累计连续登录时间
        if (continuousLoginDays.getLastLoginDate().isEqual(LocalDate.now().minusDays(1))) {
            continuousLoginDays.setDays(continuousLoginDays.getDays() + 1);
            continuousLoginDays.setLastLoginDate(LocalDate.now());
            sportUserContinuousLoginDaysMapper.updateById(continuousLoginDays);
            achievementService.handleSignInAchievement(sportUserId, continuousLoginDays.getDays());
            return;
        }
        //其他情况重置连续登录天数
        continuousLoginDays.setDays(1);
        continuousLoginDays.setLastLoginDate(LocalDate.now());
        sportUserContinuousLoginDaysMapper.updateById(continuousLoginDays);
    }

    public NewMessageVO getUserNewMessage(Long sportUserId) {
        NewMessageVO result = sportUserSummaryBusinessMapper.getUserNewMessage(sportUserId);
        result.setNewMessageCount(sportUserSummaryBusinessMapper.getUserNewMessageItem(sportUserId));
        return result;
    }
}
